//////////////////////////////////////////////////////////////////////////

function CreateBlock()
{
	gPeople.push( new oPerson(GetCurrentPerson(), OnBlockTouch, DoNothing, DoNothing, DoNothing) )
	SetPersonSpriteset( GetCurrentPerson(), LoadSpriteset("box.rss"))
}

function OnBlockTouch(other)
{
	if (other.name == "player") this.move = other.move;
}

//////////////////////////////////////////////////////////////////////////

function CreateSwitch(flag)
{
	gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, OnSwitchTalk, OnSwitchUpdate, DoNothing) )
	gPeople[gPeople.length-1].brain[0] = false
	gPeople[gPeople.length-1].brain[1] = 0
	gPeople[gPeople.length-1].brain[2] = flag
	gFlags[flag] = false;
	
	SetPersonSpriteset( GetCurrentPerson(), LoadSpriteset("switch.rss"))
}

function OnSwitchUpdate()
{
	if (this.brain[1] < 16) this.brain[1]++;
}

function OnSwitchTalk(other)
{
	if (this.brain[1] >= 16)
		{
			this.brain[1] = 0;
			
			if (this.brain[0] == false)
				{
					gFlags[this.brain[2]] = true
					this.brain[0] = true
					SetPersonDirection(this.name, "SOUTH")
				}
			else 
				{ 
					gFlags[this.brain[2]] = false
					this.brain[0] = false 
					SetPersonDirection(this.name, "NORTH")
				}
		}
}

//////////////////////////////////////////////////////////////////////////

function OnRockUpdate()
{
	if (gFlags[this.brain[0]]  == false)
		{ 
			SetPersonDirection(this.name, "NORTH")
			SetPersonLayer(this.name, 1)
		}
	else
		{
			SetPersonDirection(this.name, "SOUTH")
			SetPersonLayer(this.name, 0)
		}
}

//////////////////////////////////////////////////////////////////////////

function CreateRock(flag)
{
	gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, DoNothing, OnRockUpdate, DoNothing) )
	gPeople[gPeople.length-1].brain[0] = flag
	
	SetPersonLayer(GetCurrentPerson(), 1)
	SetPersonSpriteset( GetCurrentPerson(), LoadSpriteset("rock.rss"))	
}

//////////////////////////////////////////////////////////////////////////

function CreatePad(flag)
{
	gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, DoNothing, OnPadUpdate, DoNothing) )
	gPeople[gPeople.length-1].brain[0] = false
	gPeople[gPeople.length-1].brain[1] = flag
	
	SetPersonLayer(GetCurrentPerson(), 0)
	SetPersonSpriteset( GetCurrentPerson(), LoadSpriteset("pad.rss"))
}

//////////////////////////////////////////////////////////////////////////

function OnPadUpdate()
{
	var tx = GetPersonX(this.name)
	var ty = GetPersonY(this.name)
	var n = PersonNameToNumber(this.name)
	
	var ox, oy
	
	var found = false
	
	for (var i = 0; i < gPeople.length; i++)
		{
			ox = GetPersonX(gPeople[i].name)
			oy = GetPersonY(gPeople[i].name)
			
			if (ox == tx && oy == ty && i != n)
				{
					gFlags[this.brain[1]] = true
					this.brain[0] = true;
					found = true;
					SetPersonDirection(this.name, "SOUTH")
				}
		}
		
	if (!found) 
		{
			this.brain[0] = false;
			gFlags[this.brain[1]] = false
			SetPersonDirection(this.name, "NORTH")
		}
}

//////////////////////////////////////////////////////////////////////////

function CreateMushroom(type, amount, flag)
{
	if (gFlags[flag] != true)
		{
			gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, OnShroomTalk, DoNothing, DoNothing) )
		
			gPeople[gPeople.length-1].brain[0] = type
			gPeople[gPeople.length-1].brain[1] = amount
			gPeople[gPeople.length-1].brain[2] = flag
			
			var spr = LoadSpriteset("aegis.rss")
			
			spr.images[0] = GetImage( GetMushroomTypePicture( type ) )
			
			SetPersonSpriteset(GetCurrentPerson(), spr)
		}
	else
		{
			DestroyPerson(GetCurrentPerson())
		}
}

//////////////////////////////////////////////////////////////////////////

function OnShroomTalk()
{
	TextBox(40, 120, 100, "Got "+this.brain[1]+" mushrooms!")

	gMenuContainer.menus.push( new menu_oMenu(35, 100, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, BasicMenuRender) )		
														
	gMenuContainer.menus[1].AddChild( new menu_oChild_Image( GetImage( GetMushroomTypePicture(this.brain[0]) ) ) )							

	for (var i2 = 0; i2 < this.brain[1]; i2++)
		gPlayer_Mushrooms.push( new ItemBuild_oBlock(0, 0, this.brain[0]) )
		
	gFlags[this.brain[2]] = true;
	
	this.dead = true
}

//////////////////////////////////////////////////////////////////////////

function CreateSailor()
{
	gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, OnSailorTalk, DoNothing, DoNothing) )
}

function OnSailorTalk()
{
	if (gPlayer_Ship == -1)
		{
			LeaveSailor()
			TextBox(100, 60, 200, "We have no ship!")			
		}
	else
		{
			LeaveSailor()
			LeaveSailor()
			
			if (gFlags[10] == false)
				{					
					
					txt_ShipBuilt()
					WaitForText()
					
					GenerateShipBattle([0,1], 0, 20)
					gFlags[10] = true;
				}
			else
				{
					GoToOverworld()
					
					gFlags[16] = false
					gFlags[17] = false
					gFlags[18] = false
					gFlags[22] = false
					gFlags[23] = false				
					gFlags[27] = false
					gFlags[32] = false
					gFlags[33] = false
					gFlags[34] = false
					gFlags[35] = false			
					gFlags[46] = false
					gFlags[47] = false
					gFlags[48] = false
					
				}
		}
}

function LeaveSailor()
{
	gSuspendMovement = true

	gMenuContainer.on = false
	
	n = GetPlayer()
	
	gPeople[n].move = 0
	
	while (gPeople[n].move != -1)
		{
			RenderMap()
			RenderProcess_Manager_Run()
			UpdateProcess_Manager_Run()
			
			FlipScreen()
		}
	
	gSuspendMovement = false;
}

//////////////////////////////////////////////////////////////////////////

function CreateMushroomNoFlag(type, amount)
{
	gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, OnShroomTalkNoFlag, DoNothing, DoNothing) )
		
	gPeople[gPeople.length-1].brain[0] = type
	gPeople[gPeople.length-1].brain[1] = amount
			
	var spr = LoadSpriteset("aegis.rss")
			
	spr.images[0] = GetImage( GetMushroomTypePicture( type ) )
			
	SetPersonSpriteset(GetCurrentPerson(), spr)
}

//////////////////////////////////////////////////////////////////////////

function OnShroomTalkNoFlag()
{
	TextBox(40, 120, 100, "Got "+this.brain[1]+" mushrooms!")

	gMenuContainer.menus.push( new menu_oMenu(35, 100, STYLE_VERTICAL, "style.rws", 
														BasicMenuUpdate, BasicMenuRender) )		
														
	gMenuContainer.menus[1].AddChild( new menu_oChild_Image( GetImage( GetMushroomTypePicture(this.brain[0]) ) ) )							

	for (var i2 = 0; i2 < this.brain[1]; i2++)
		gPlayer_Mushrooms.push( new ItemBuild_oBlock(0, 0, this.brain[0]) )
	
	this.dead = true
}